#pragma	once

#include "links.h"
#include "libIncludes\MiniSAX.h"


/*******************************************
  Classes to parse links configuration data
 *******************************************/


using	miniSAX::CMiniSAXException;
using	miniSAX::CContentHandler;
using	miniSAX::CAttribute;
using	miniSAX::CAttributeList;
using	miniSAX::CMiniSAXParser;


class CLinkContentHandler : public CContentHandler {
public:
    CLinkContentHandler(CMiniSAXParser* aParser);
    virtual ~CLinkContentHandler() {}

    virtual void startElement(const char* name, const CAttributeList& attributes)
        throw (CMiniSAXException);
    virtual void endElement(const char* name)
        throw (CMiniSAXException);

    virtual void handleCharacters(const char* buffer, size_t len)
        throw (CMiniSAXException);

	bool elementEnded() const { return endOfElement; }

protected:
	int		state;
	PLink	link;
	bool	endOfElement;

	enum states {
		WAIT_STATE,
		NAME_STATE,
		ADDRESS_STATE,
		OUTBOUND_STATE,
		ALLOW_AREA_CREATION_STATE,
		PATH_STATE,
		DEFAULT_GROUP_STATE,
		AUTOCREATED_SEND_PRIORITY_STATE,
		AUTOCREATED_RECEIVE_PRIORITY_STATE,
		STATUS_STATE,
		ROBOT_NAME_STATE,
		AVAIL_AREAS_STATE,
		USE_AKA_STATE,
		SECURITY_STATE,
		PASSWORD_STATE,
		SEND_PRIORITY_STATE,
		RECEIVE_PRIORITY_STATE,
		GROUP_STATE
	};

	CMiniSAXParser*	parser;
};


class CLinksContentHandler : public CContentHandler {
public:
    CLinksContentHandler(CMiniSAXParser* aParser);
    virtual ~CLinksContentHandler();

    virtual void startElement(const char* name, const CAttributeList& attributes)
        throw (CMiniSAXException);
    virtual void endElement(const char* name)
        throw (CMiniSAXException);

    virtual void handleCharacters(const char* buffer, size_t len)
        throw (CMiniSAXException);

protected:
	CLinkContentHandler*	linkContentHandler;
	int						state;
	enum states {
		ROOT_STATE,
		LINKS_STATE
	};

	CMiniSAXParser*	parser;
};


